#!/usr/bin/python

"""
Demo data producer. 
Parameters:
  -f, --file output location

Writes data to [file] like:
ts    | data1 | data2 | ... 
where [ts] is a microsecond unix timestamp
[data1..N] are values from the sensor

Example output:

12345    1.0     2.0

--------------------
John Donnal 2016
"""

import argparse
import numpy as np
from nilmdb.utils.time import now
import time

F = 1/1000.0 #frequency of data sine waves

def main(dest_file):
    t = 0
    with open(dest_file,'w') as fp:
        while(True):
            #generate 'data' and a timestamp
            ts = now()
            data1 = 10*np.sin(2*np.pi*F*t)
            data2 = 10*np.cos(2*np.pi*F*t)
            #print it out to the file
            #fp.write("%d %0.3f %0.3f\n"%(ts, data1, data2))
            print("%d %0.3f %0.3f"%(ts, data1, data2))
            
            fp.flush()
            #print("%d %0.3f %0.3f"%(ts, data1, data2))
            #sleep for 1 second
            time.sleep(0.2)
            #increment time
            t+=1
        
if __name__ == "__main__":
    parser = argparse.ArgumentParser( description = "Demo data producer")
    parser.add_argument("-f", "--file", help="output file", default="data.txt")
    args = parser.parse_args()
    main(args.file)

