#!/usr/bin/python

# To release a new version, tag it:
#   git tag -a datacapture-1.1 -m "Version 1.1"
#   git push --tags
# Then just package it up:
#   python setup.py sdist

# This is supposed to be using Distribute:
#
#   distutils provides a "setup" method.
#   setuptools is a set of monkeypatches on top of that.
#   distribute is a particular version/implementation of setuptools.
#
# So we don't really know if this is using the old setuptools or the
# Distribute-provided version of setuptools.

import traceback
import sys
import os

try:
    from setuptools import setup, find_packages
    import distutils.version
except ImportError:
    traceback.print_exc()
    print "Please install the prerequisites listed in README.txt"
    sys.exit(1)

# Hack to workaround logging/multiprocessing issue:
# https://groups.google.com/d/msg/nose-users/fnJ-kAUbYHQ/_UsLN786ygcJ
try: import multiprocessing
except: pass

# We need a MANIFEST.in.  Generate it here rather than polluting the
# repository with yet another setup-related file.
with open("MANIFEST.in", "w") as m:
    m.write("""
# Root
include README.txt
include setup.py
include Makefile
""")

# Run setup
setup(name='datacapture',
      version = 1.0,
      url = 'https://git.wattsworth.net/wattsworth/data-capture.git',
      author = 'John Donnal',
      description = "NILM Data Capture Utility",
      long_description = "Add timestamped data to a NILM stream",
      license = "Proprietary",
      author_email = 'jdonnal@mit.edu',
      install_requires = [ 'nilmdb >= 1.8.5',
                           'numpy',
                           ],
      packages = [ 'datacapture',
                   ],
      entry_points = {
          'console_scripts': [
              'nilm-consume = datacapture.consumer:main',
              ],
          },
      zip_safe = False,
      )
