"""
Encapsulates a DbFile (NilmDb Stream)
  Has one or more DbStreams

John Donnal 2016
"""

from db_stream import DbStream

class DbFile:

    def buildFromConfig(self,config):

        def get(key,default):
            try:
                return config[key]
            except KeyError:
                return default
            
        #1. Get File info from config
        try:
            self.name = config['name']
            self.name_abbrev = get('abbreviation',"")
            self.description = get('description', "")
        except:
            print "[ERROR]: missing 'name' configuration"
            return False
        
        #2. Build streams from config
        self.streams = []
        i = 0 #assign columns to streams
        names = [] #accumate stream names
        for entry in config['schema']:
            stream = DbStream()
            stream.column = i
            if(stream.buildFromConfig(entry)==False):
                return False # error building stream
            # don't count ignored streams
            if(stream.name == "[ignore]"):
                next
            # make sure the names are unique
            if(stream.name in names):
                print "[ERROR]: '%s' stream names must be unique"\
                    %stream.name
                return False
            names.append(stream.name)
            i+=1
            self.streams.append(stream)
                

        #4. all done, return
        return True

    def getConfig(self):
        return {
            'streams': [x.getConfig() for x in self.streams],
            'name': self.name,
            'name_abbrev': self.name_abbrev,
            'description': self.description
        }

    def numCols(self):
        return len(self.streams)
    
