""""
Encapuslates a DbStream (NilmDB stream column)

John Donnal 2016
"""

class DbStream:

    def buildFromConfig(self,config):

        def get(key,default):
            try:
                return config[key]
            except KeyError:
                return default
            
        try:
            self.name = config['name']
            self.default_min = get('default_min', None)
            self.default_max = get('default_max', None)
            self.offset = float(get('offset',0))
            self.scale_factor = float(get('scale_factor',1.0))
            self.plottable = bool(get('plottable',True))
            self.discrete = bool(get('discrete',False))
        except ValueError:
            print "[ERROR] Stream %s: %s"%(self.name,e[0])
        except KeyError:
            print "[ERROR] Stream missing config '%s'"%e[0]
    
    def getConfig(self):
        return {
            'name': self.name,
            'default_min': self.default_min,
            'default_max': self.default_max,
            'scale_factor': self.scale_factor,
            'offset': self.offset,
            'plottable': self.plottable,
            'discrete': self.discrete,
            'column': self.column
        }
    
