
import subprocess
import os
import json
import psutil


def main():
    proc = psutil.Process()
    print("parent before: %d" % proc.num_fds())

    (p1_r, p1_w) = os.pipe()
    (p2_r, p2_w) = os.pipe()
    os.set_inheritable(p1_w, True)
    os.set_inheritable(p2_w, True)
    print("parent after: %d" % proc.num_fds())

    sources = {
        "path1": p1_w,
        "path2": p2_w
    }
    print("%d->%d, %d->%d" % (p1_w, p1_r, p2_w, p2_r))
    proc1 = subprocess.Popen(
        ["python", "test_sub.py", "--sources", json.dumps(sources)], close_fds=False)
    os.close(p1_w)
    os.close(p2_w)
    print("parent writes closed: %d" % proc.num_fds())

    proc1.communicate()
    proc1.kill()


if __name__ == "__main__":
    main()
