#!/usr/bin/env python

from setuptools import setup, find_packages

PROJECT = 'joulelabjack'

# Change docs/sphinx/conf.py too!

try:
    long_description = open('README', 'rt').read()
except IOError:
    long_description = ''

setup(
    name=PROJECT,
    version='0.5.1',  # versioneer.get_version(),
    #cmdclass=versioneer.get_cmdclass(),
    description='Use the LabJack U3 with Joule',
    long_description=long_description,

    author='John Donnal',
    author_email='donnal@usna.edu',

    url='https://git.wattsworth.net/wattsworth/labjack-module.git',
    download_url='[none]',

    classifiers=['Programming Language :: Python',
                 'Environment :: Console',
                 ],
    platforms=['Any'],
    scripts=[],
    provides=[],
    install_requires=['numpy',
                      'joule'],
    namespace_packages=[],
    packages=find_packages(),
    include_package_data=True,

    entry_points={
        'console_scripts': [
            'labjack_u3 = joulelabjack.u3_module:main',
        ],
    },
    zip_safe=False,
)
