from enum import IntEnum
import logging


HELP_URL = "http://nilm.standalone/help/"
# Print formatted error message
#  If a url is provided print this too
#

ESC_SEQ = "\x1b["
COL_RESET = ESC_SEQ+"0m"
COL_RED = ESC_SEQ+"6;30;41m"
COL_GREEN = ESC_SEQ+"6;30;42m"
COL_YELLOW = ESC_SEQ+"6;30;43m"
COL_BLUE = ESC_SEQ+"34;01m"
COL_MAGENTA = ESC_SEQ+"35;01m"
COL_CYAN = ESC_SEQ+"36;01m"

def print_error(msg, url=""):
    logging.error("["+COL_RED+"ERROR"+COL_RESET+"]: %s" % msg)
    if(url != ""):
        logging.error("\tsee [%s] for help" % (HELP_URL + url))

# Print formatted warning message
#  If a url is provided print this too
#


def print_warning(msg, url=""):
    logging.warning("["+COL_YELLOW+"WARN"+COL_RESET+"]: %s" % msg)
    if(url != ""):
        logging.warn("\tsee [%s] for help" % (HELP_URL + url))


class Status(IntEnum):
    ok = 0
    warn = -1
    error = -2


class MeterError(Exception):
    """Base class for exceptions in this module"""
    pass


class MeterConfigurationError(MeterError):
    pass
