
import os
import yaml

from nilm.meter.utils import MeterConfigurationError


def load_calibration(directory, meter):
    cal_file = os.path.join(directory, meter['name'] + '.yml')
    if(not os.path.isfile(cal_file)):
        meter['calibrated'] = False
        return
    try:
        with open(cal_file, 'r') as f:
            cal = yaml.load(f)
    except Exception as e:
        raise MeterConfigurationError(str(e)) from e

    meter['calibrated'] = True
    if('calibration' in meter):
        #prefer hard coded values in meters.yml over cal file
        meter['calibration'] = {**cal,
                                **meter['calibration']}
    else:
        meter['calibration'] = cal
