
import unittest
from unittest import mock
from nilm.meter import meter
import os

CAL_DIR = os.path.join(os.path.dirname(
    __file__), 'files', 'default_cal')


class TestMeter(unittest.TestCase):

    @mock.patch("nilm.meter.storage.Client", autospec=True)
    def setUp(self, client):
        self.instance = client.return_value
        # values from bucket
        self.instance.dbinfo = mock.Mock(
            return_value={"path":     '/home/nilmdb',
                          "other":    9180803731456,
                          "reserved": 147308150784,
                          "free":     978309853184,
                          "size":     4364062072832})

    def test_loads_meters_from_config_file(self):
        meter_file = self.gen_meter_config("default")
        meters = meter.load_meters(meter_file, CAL_DIR)
        self.assertEqual(len(meters), 4)
        # make sure meters all have a voltage_scale
        for m in meters:
            if(meters[m]['calibrated']):
                scale = meters[m]['calibration']['voltage_scale']
                if(m == "meter1"):
                    self.assertEqual(scale, 1)  # default
                else:
                    self.assertLess(scale, 1)  # all explicit values are < 1
            
    def gen_meter_config(self, name):
        return os.path.join(os.path.dirname(
            __file__), 'files', 'good_configs', name+'.yml')

    
