import os
import asyncio
import unittest
import asynctest
from unittest import mock
import numpy as np

from nilm.readers.ethstreamcapture import EthstreamCapture
from joule import LocalNumpyPipe


ETHSTREAM_DUMP = os.path.join(os.path.dirname(
    __file__), 'capture_dumps', 'ethstream_data.bin')


class TestEthstreamCaptureCmd(unittest.TestCase):

    def setUp(self):
        with open(ETHSTREAM_DUMP, "rb") as f:
            self.ethstream_data = f.read()

    def test_starts_ethstream(self):

        mock_proc = mock.Mock()
        mock_proc.stdout.readexactly = asynctest.CoroutineMock(
            return_value=self.ethstream_data)
        ec = EthstreamCapture("192.168.1.209")
        ec._start_meter = asynctest.CoroutineMock(return_value=mock_proc)
        npipe_output = LocalNumpyPipe("raw", layout="uint16_6")

        async def output_func(data):
            # check data output
            ec.stop()

        loop = asyncio.get_event_loop()
        loop.run_until_complete(ec.run(npipe_output,
                                       align=True,
                                       nrows=1000))

        # check the data
        result = npipe_output.read_nowait(flatten=True)
        expected_data = np.frombuffer(self.ethstream_data, dtype="uint16")
        expected_data.shape = (1000, 6)
        np.testing.assert_array_equal(result[:, 1:], expected_data)

        # make sure ethstream subprocess is stopped
        mock_proc.terminate.assert_called_once_with()
