#!/usr/bin/env python

PROJECT = 'Nilm'

# Change docs/sphinx/conf.py too!
from setuptools import setup, find_packages

try:
    long_description = open('README.rst', 'rt').read()
except IOError:
    long_description = ''

setup(
    name=PROJECT,
    version='0.7.4',
    # cmdclass=versioneer.get_cmdclass(),
    description='Tools for Non-Intrusive Load Monitoring',
    long_description=long_description,

    author='John Donnal',
    author_email='donnal@usna.edu',

    url='https://git.wattsworth.net/wattsworth/nilm.git',
    download_url='[none]',

    classifiers=['Programming Language :: Python',
                 'Environment :: Console',
                 ],
    platforms=['Any'],
    scripts=[],
    provides=[],
    
    install_requires=['cliff',
                      'numpy',
                      'psutil',
                      'requests',
                      'pyyaml',
                      'pyserial',
                      'matplotlib'],
    namespace_packages=[],
    packages = find_packages(exclude = ["test"]),
    include_package_data=True,

    entry_points={
        'console_scripts': [
            'nilm = nilm.scripts.cliff:main',
            'nilm-filter-prep = nilm.filters.prep:main',
            'nilm-filter-sinefit = nilm.filters.sinefit:main',
            'nilm-filter-reconstructor = nilm.filters.reconstructor:main',
            'nilm-filter-rawtoprep = nilm.filters.rawtoprep:main',
            'nilm-reader-capture = nilm.readers.capture:main',
        ],
        'nilm.commands': [
            'initialize = nilm.cmds.initialize:InitializeCmd',
            'configure  = nilm.cmds.configure:ConfigureCmd',
            'calibrate  = nilm.cmds.calibrate.cliff_cmd:CalibrateCmd',
            'udev       = nilm.cmds.udev:UdevCmd',
            'scope      = nilm.cmds.scope:ScopeCmd'
        ],
    },
    zip_safe=False,
)
