
from cliff.command import Command
import pkg_resources
import shutil
import os
import sys

ESC_SEQ = "\x1b["
COL_RESET = ESC_SEQ+"0m"
COL_RED = ESC_SEQ+"6;30;41m"
COL_GREEN = ESC_SEQ+"6;30;42m"
COL_YELLOW = ESC_SEQ+"6;30;43m"
COL_BLUE = ESC_SEQ+"34;01m"
COL_MAGENTA = ESC_SEQ+"35;01m"
COL_CYAN = ESC_SEQ+"36;01m"


class InitializeCmd(Command):
    "install nilm system files"

    def take_action(self, parsed_args):
        sys.stdout.write("1. adding udev entry for nilm devices ")
        udev_file = pkg_resources.resource_filename(
            "nilm", "resources/90-meter.rules")
        try:
            shutil.copy(udev_file, "/etc/udev/rules.d")
        except(PermissionError):
            self.run_as_root()        
        print("["+COL_GREEN+"OK"+COL_RESET+"]")
        
        sys.stdout.write("2. copying meter examples to /opt/configs ")
        self.make_directory("/opt/configs")
        self.make_directory("/opt/configs/meters")
        example_file = pkg_resources.resource_filename(
                "nilm", "resources/meters.example.yml")
        shutil.copy(example_file, "/opt/configs")
        print("["+COL_GREEN+"OK"+COL_RESET+"]")
        
    def make_directory(self, path):
        try:
            # check if directory exists
            if(not os.path.isdir(path)):
                os.mkdir(path)
        except(PermissionError):
            self.run_as_root
            
    def run_as_root(self):
        print("["+COL_RED+"ERROR"+COL_RESET+"]\n run as [sudo nilm initialize]")
        exit(1)
