import os
import re
from cliff.command import Command

"""
 produce an interface name
 using environment variables
 from UDEV
"""


class UdevCmd(Command):
    """udev hook for naming NILM devices"""

    def take_action(self, parsed_args):

        """
        # set up the logger
        formatter = logging.Formatter('%(asctime)s:%(levelname)s:%(message)s')
        log_handler = logging.handlers.WatchedFileHandler(LOG_FILE)
        log_handler.setLevel(LOG_LEVEL)
        log_handler.setFormatter(formatter)

        udev_log = logging.getLogger('STDOUT')
        udev_log.setLevel(LOG_LEVEL)
        udev_log.addHandler(log_handler)
        """
        # ID_VENDOR_ENC=MIT
        # ID_MODEL_ENC=meter*
        # ID_USB_INTERFACE_NUM=[00,02]

        # first make sure this is a USB MTI
        # device, if not label the device "ERROR"

        vendor = os.environ.get('ID_VENDOR')
        if vendor != "MIT":
            exit(1)

        # only label non-contact meters
        model = os.environ.get('ID_MODEL_ENC')
        if re.match("^meter\w+$", model) is None:
            exit(1)

        # interface 00 is data, 02 is control
        interface = os.environ.get('ID_USB_INTERFACE_NUM')
        if interface != '00' and interface != '02':
            # don't name the root interface
            exit(1)

        if interface == '00':
            name = "%s-data" % model
            print(name)
            exit(0)

        if interface == '02':
            name = "%s-ctrl" % model
            print(name)
            exit(0)
