from nilm.meter.utils import print_error, Status
import re

# Check the stream configuration
#


def check_stream_config(name, stream, config, allow_no_keep=True):
    # 1 make sure the config is a dict
    if(not(type(config) is dict)):
        print_error("%s invalid [streams][%s] settings" % (name, stream))
        return Status.error
    try:
        # 2 check the keep flag
        x = config["keep"]
        if((not (type(x) is str)) and
           (not (type(x) is bool))):
            print_error(
                "%s invalid [streams][%s][keep] value" % (name, stream))
            return Status.error

        if(x is False or x.lower() == "none"):
            if(allow_no_keep):
                config["keep"] = "none"
                config["decimate"] = False  # nothing to decimate
            else:
                print_error("%s stream [%s] must be kept, change [streams][%s][keep] setting" %
                            (name, stream, stream))
            return Status.ok

        # 2a check the syntax
        if(re.match("^\d+[hdwmy]$", x) is None):
            print_error(
                "%s error in [streams][%s][keep] bad syntax" % (name, stream))
            return Status.error
        # 2b check the decimation flag
        y = config["decimate"]
        if(not (type(y) is bool)):
            print_error(
                "%s invalid [streams][%s][decimate] setting, must be [true|false]" % (name, stream))
            return Status.error

    except KeyError as e:
        print_error("%s error in [streams][%s]: missing [%s]" % (
            name, stream, e))
        return Status.error
    except AttributeError as e:
        print_error("%s error in [streams][%s]: " % (name, stream) +
                    "invalid keep or decimate setting")

        return Status.error
                    
    return Status.ok
