#!/usr/bin/python

import nilmdb.fsck
import argparse
import os
import sys

def main():
    """Main entry point for the 'nilmdb-fsck' command line script"""

    parser = argparse.ArgumentParser(
        description = 'Check database consistency',
        formatter_class = argparse.ArgumentDefaultsHelpFormatter,
        version = nilmdb.__version__)
    parser.add_argument("-f", "--fix", action="store_true",
                        default=False, help = 'Fix errors when possible '
                        '(which may involve removing data)')
    parser.add_argument("-n", "--no-data", action="store_true",
                        default=False, help = 'Skip the slow full-data check')
    parser.add_argument('database', help = 'Database directory')
    args = parser.parse_args()

    nilmdb.fsck.Fsck(args.database, args.fix).check(skip_data = args.no_data)

if __name__ == "__main__":
    main()
