"""nilmdb.server"""

from __future__ import absolute_import

# Try to set up pyximport to automatically rebuild Cython modules.  If
# this doesn't work, it's OK, as long as the modules were built externally.
# (e.g. python setup.py build_ext --inplace)
try: # pragma: no cover
    import Cython
    import distutils.version
    if (distutils.version.LooseVersion(Cython.__version__) <
        distutils.version.LooseVersion("0.17")): # pragma: no cover
        raise ImportError("Cython version too old")
    import pyximport
    pyximport.install(inplace = True, build_in_temp = False)
except (ImportError, TypeError): # pragma: no cover
    pass

from nilmdb.server.nilmdb import NilmDB
from nilmdb.server.server import Server, wsgi_application
from nilmdb.server.errors import NilmDBError, StreamError, OverlapError
