import re

def sort_human(items, key = None):
    """Human-friendly sort (/stream/2 before /stream/10)"""
    def to_num(val):
        try:
            return int(val)
        except Exception:
            return val

    def human_key(text):
        if key:
            text = key(text)
        # Break into character and numeric chunks.
        chunks = re.split(r'([0-9]+)', text)
        return [ to_num(c) for c in chunks ]

    return sorted(items, key = human_key)
