# nilmdb: Non-Intrusive Load Monitor Database
by Jim Paris <jim@jtan.com>

NilmDB requires Python 3.7 or newer.

## Prerequisites:

    # Runtime and build environments
    sudo apt install python3.7 python3.7-dev python3.7-venv python3-pip

    # Optional: create a new Python virtual environment to isolate
    # dependencies.  To leave the virtual environment, run "deactivate"
    python -m venv venv
    source venv/bin/activate

    # Install all Python dependencies from PyPI.
    pip3 install -r requirements.txt

## Test:

    python3 setup.py nosetests

## Install:

Install it in a per-user location (e.g. `$HOME/.local/bin/nilmtool`)

    python3 setup.py install --user

If you want to install it system-wide, you may need to also install the
requirements system-wide:

    sudo pip3 install -r requirements.txt
    sudo python3 setup.py install

## Usage:

    nilmdb-server --help
    nilmdb-fsck --help
    nilmtool --help

See docs/wsgi.md for info on setting up a WSGI application in Apache.
