# To enable bash completion:
#
# 1. Ensure python-argcomplete is installed:
#       pip install argcomplete
# 2. Source this file:
#       . nilmtool-bash-completion.sh

_nilmtool_argcomplete() {
    local IFS=$(printf "\013")
    COMPREPLY=( $(IFS="$IFS" \
                  COMP_LINE="$COMP_LINE" \
	          COMP_WORDBREAKS="$COMP_WORDBREAKS" \
                  COMP_POINT="$COMP_POINT" \
                  _ARGCOMPLETE=1 \
                  "$1" 8>&1 9>&2 1>/dev/null 2>/dev/null) )
    if [[ $? != 0 ]]; then
        unset COMPREPLY
    fi
}
complete -o nospace -F _nilmtool_argcomplete nilmtool
