from argparse import ArgumentDefaultsHelpFormatter as def_form

import nilmdb.client
from nilmdb.utils.printf import printf
from nilmdb.utils import human_size


def setup(self, sub):
    cmd = sub.add_parser("info", help="Server information",
                         formatter_class=def_form,
                         description="""
                         List information about the server, like
                         version.
                         """)
    cmd.set_defaults(handler=cmd_info)
    return cmd


def cmd_info(self):
    """Print info about the server"""
    printf("Client version: %s\n", nilmdb.__version__)
    printf("Server version: %s\n", self.client.version())
    printf("Server URL: %s\n", self.client.geturl())
    dbinfo = self.client.dbinfo()
    printf("Server database path: %s\n", dbinfo["path"])
    for (desc, field) in [("used by NilmDB", "size"),
                          ("used by other", "other"),
                          ("reserved", "reserved"),
                          ("free", "free")]:
        printf("Server disk space %s: %s\n", desc, human_size(dbinfo[field]))
