# Implementation of hole punching via fallocate, if the OS
# and filesystem support it.

import fallocate


def punch_hole(filename, offset, length, ignore_errors=True):
    """Punch a hole in the file.  This isn't well supported, so errors
    are ignored by default."""
    try:
        with open(filename, "r+") as f:
            fallocate.fallocate(
                f.fileno(),
                offset,
                length,
                fallocate.FALLOC_FL_KEEP_SIZE | fallocate.FALLOC_FL_PUNCH_HOLE)
    except Exception:
        if ignore_errors:
            return
        raise
