# nilmdb: Non-Intrusive Load Monitor Database
by Jim Paris <jim@jtan.com>

NilmDB requires Python 3.8 or newer.

## Prerequisites:

    # Runtime and build environments
    sudo apt install python3 python3-dev python3-venv python3-pip

    # Create a new Python virtual environment to isolate deps.
    python3 -m venv ../venv
    source ../venv/bin/activate   # run "deactivate" to leave

    # Install all Python dependencies
    pip3 install -r requirements.txt

## Test:

    python3 setup.py nosetests

## Install:

Install it into the virtual environment

    python3 setup.py install

If you want to instead install it system-wide, you will also need to
install the requirements system-wide:

    sudo pip3 install -r requirements.txt
    sudo python3 setup.py install

## Usage:

    nilmdb-server --help
    nilmdb-fsck --help
    nilmtool --help

See docs/wsgi.md for info on setting up a WSGI application in Apache.
