from argparse import RawDescriptionHelpFormatter as raw_form

import nilmdb.client


def setup(self, sub):
    cmd = sub.add_parser("create", help="Create a new stream",
                         formatter_class=raw_form,
                         description="""
Create a new empty stream at the specified path and with the specified
layout type.

Layout types are of the format: type_count

  'type' is a data type like 'float32', 'float64', 'uint16', 'int32', etc.

  'count' is the number of columns of this type.

  For example, 'float32_8' means the data for this stream has 8 columns of
  32-bit floating point values.
""")
    cmd.set_defaults(handler=cmd_create)
    group = cmd.add_argument_group("Required arguments")
    group.add_argument("path",
                       help="Path (in database) of new stream, e.g. /foo/bar",
                       ).completer = self.complete.path
    group.add_argument("layout",
                       help="Layout type for new stream, e.g. float32_8",
                       ).completer = self.complete.layout
    return cmd


def cmd_create(self):
    """Create new stream"""
    try:
        self.client.stream_create(self.args.path, self.args.layout)
    except nilmdb.client.ClientError as e:
        self.die("error creating stream: %s", str(e))
