from argparse import ArgumentDefaultsHelpFormatter as def_form

import nilmdb.client


def setup(self, sub):
    cmd = sub.add_parser("rename", help="Rename a stream",
                         formatter_class=def_form,
                         description="""
                         Rename a stream.

                         Only the stream's path is renamed; no
                         metadata is changed.
                         """)
    cmd.set_defaults(handler=cmd_rename)
    group = cmd.add_argument_group("Required arguments")
    group.add_argument("oldpath",
                       help="Old path, e.g. /foo/old",
                       ).completer = self.complete.path
    group.add_argument("newpath",
                       help="New path, e.g. /foo/bar/new",
                       ).completer = self.complete.path

    return cmd


def cmd_rename(self):
    """Rename a stream"""
    try:
        self.client.stream_rename(self.args.oldpath, self.args.newpath)
    except nilmdb.client.ClientError as e:
        self.die("error renaming stream: %s", str(e))
