# File locking

import fcntl
import errno


def exclusive_lock(f):
    """Acquire an exclusive lock.  Returns True on successful
    lock, or False on error."""
    try:
        fcntl.flock(f.fileno(), fcntl.LOCK_EX | fcntl.LOCK_NB)
    except IOError as e:
        if e.errno in (errno.EACCES, errno.EAGAIN):
            return False
        else:
            raise
    return True


def exclusive_unlock(f):
    """Release an exclusive lock."""
    fcntl.flock(f.fileno(), fcntl.LOCK_UN)
