#!/usr/bin/env python3

# To release a new version, tag it:
#   git tag -a nilmdb-1.1 -m "Version 1.1"
#   git push --tags
# Then just package it up:
#   python3 setup.py sdist

import sys
import os
from setuptools import setup
from distutils.extension import Extension

# Versioneer manages version numbers from git tags.
# https://github.com/warner/python-versioneer
import versioneer

# External modules that need to be built
ext_modules = [ Extension('nilmdb.server.rocket', ['nilmdb/server/rocket.c' ]) ]

# Use Cython.
cython_modules = [ 'nilmdb.server.interval', 'nilmdb.server.rbtree' ]
import Cython
from Cython.Build import cythonize
for modulename in cython_modules:
    filename = modulename.replace('.','/')
    ext_modules.extend(cythonize(filename + ".pyx"))

# Get list of requirements to use in `install_requires` below.  Note
# that we don't make a distinction between things that are actually
# required for end-users vs developers (or use `test_requires` or
# anything else) -- just install everything for simplicity.
install_requires = open('requirements.txt').readlines()

# Run setup
setup(name='nilmdb',
      version = versioneer.get_version(),
      cmdclass = versioneer.get_cmdclass(),
      url = 'https://git.jim.sh/nilm/nilmdb.git',
      author = 'Jim Paris',
      description = "NILM Database",
      long_description = "NILM Database",
      license = "Proprietary",
      author_email = 'jim@jtan.com',
      setup_requires = [ 'setuptools' ],
      install_requires = install_requires,
      packages = [ 'nilmdb',
                   'nilmdb.utils',
                   'nilmdb.server',
                   'nilmdb.client',
                   'nilmdb.cmdline',
                   'nilmdb.scripts',
                   'nilmdb.fsck',
                   ],
      entry_points = {
          'console_scripts': [
              'nilmtool = nilmdb.scripts.nilmtool:main',
              'nilmdb-server = nilmdb.scripts.nilmdb_server:main',
              'nilmdb-fsck = nilmdb.scripts.nilmdb_fsck:main',
              ],
          },
      ext_modules = ext_modules,
      zip_safe = False,
      )
