WSGI Application in Apache
--------------------------

Install `apache2` and `libapache2-mod-wsgi`

We'll set up the database server at URL `http://myhost.com/nilmdb`.
The database will be stored in `/home/nilm/db`, and the process will
run as user `nilm`, group `nilm`.

First, create a WSGI script `/home/nilm/nilmdb.wsgi` containing:

    import nilmdb.server
    application = nilmdb.server.wsgi_application("/home/nilm/db", "/nilmdb")

The first parameter is the local filesystem path, and the second
parameter is the path part of the URL.

Then, set up Apache with a configuration like:

    <VirtualHost>
        WSGIScriptAlias /nilmdb /home/nilm/nilmdb.wsgi
        WSGIDaemonProcess nilmdb-procgroup threads=32 user=nilm group=nilm
        <Location /nilmdb>
            WSGIProcessGroup nilmdb-procgroup
            WSGIApplicationGroup nilmdb-appgroup

            # Access control example:
            Order deny,allow
            Deny from all
            Allow from 1.2.3.4
        </Location>
    </VirtualHost>
