# Atomic file writing helper.

import os


def replace_file(filename, content):
    """Attempt to atomically and durably replace the filename with the
    given contents"""

    newfilename = filename + b".new"

    # Write to new file, flush it
    with open(newfilename, "wb") as f:
        f.write(content)
        f.flush()
        os.fsync(f.fileno())

    # Move new file over old one
    os.replace(newfilename, filename)
