# -*- coding: utf-8 -*-

# Simple timer to time a block of code, for optimization debugging
# use like:
#   with nilmdb.utils.Timer("flush"):
#       foo.flush()

import contextlib
import time


@contextlib.contextmanager
def Timer(name=None, tosyslog=False):
    start = time.time()
    yield
    elapsed = int((time.time() - start) * 1000)
    msg = (name or 'elapsed') + ": " + str(elapsed) + " ms"
    if tosyslog:
        import syslog
        syslog.syslog(msg)
    else:
        print(msg)
