import matplotlib
import matplotlib.pyplot as plt
from random import randint
import os
""" 
Manage matplotlib figures
Temporarily Save to local filesystem, generate urls,
and garabage collect
"""

class FigureHandler(object):

    def __init__(self,prefix,report_id):
        self.figures = []
        self.prefix = prefix
        self.report_id = report_id

    def saveFigure(self,fig,handle):
        #make sure the handle is unique
        for f in self.figures:
            if(f.handle==handle):
                print "figure [%s] already created"
                return None
        #create the figure and add it to the array
        f = Figure(handle,fig,self.prefix,len(self.figures))
        self.figures.append(f)

    #return "![%s](/reports/%s/images/%s?s=%d)" % \ (markdown version)
    def generateLink(self,handle):
        for f in self.figures:
            #add a random number to link to prevent caching
            if f.handle==handle:
                return '<img alt="%s" src="/reports/%s/images/%s?s=%d"></img>' % \
                        (handle, self.report_id,f.index,randint(0,100))
            
        print "figure [%s] does not exist" % handle
        return None
    
    def destroyFigures(self):
        for f in self.figures:
            f.destroy_data()

    def figureDict(self):
        files = {}
        for f in self.figures:
            files["%d"%f.index]=open(f.file_name,'rb')
        return files
        

class Figure:
    def __init__(self,handle,fig,prefix,index):
        self.handle = handle
        self.index = index
        self.file_name = "%s_%d.png" %(prefix,index)
        plt.savefig(self.file_name)

    def destroy_data(self):
        os.remove(self.file_name)

