#!/usr/bin/python

from nilmdb.utils.printf import *
from nilmdb.utils.time import (parse_time, timestamp_to_human,
                               timestamp_to_seconds)
from nilmdb.utils.interval import Interval
#import ipdb
#use: ipdb.set_trace()


import itertools
import argparse
import numpy as np
import sys
from scipy.interpolate import interp1d
import pdb

from nilmtools.state import State
from nilmtools.multi_stream_filter import Filter
    
master=None

class Resample(object):
    
    def __init__(self):
        self._filter = Filter()
    
    def setup_parser(self,name):
        parser = self._filter.setup_parser(name)
        group = parser.add_argument_group("Resampling options")
        group.add_argument('-m', '--master', action='store', type=int,
                       help='The stream to resample against '+
                       '(usually the highest bandwidth stream')
        self._parser = parser
        return parser

    def parse_args(self, argv=None):
        args = self._filter.parse_args(argv)
        
        master = args.master
        if master==None:
            self._parser.error("a master stream must be specified for resampling")
    #make sure the master stream is one of the inputs
        error=True
        self.master_col = args.master
        if self.master_col < 0 or self.master_col >= self._filter.inputWidth:
            self._parser.error("master stream [%s] must be one of the input streams" % master)

        return args
    
    #misc helpers

    #manually set the start and end bounds to override the 
    #args values
    def resetInterval(self, start,end):
        self._filter.resetInterval(start,end)

    def sourceExtents(self):
        return self._filter.sourceExtents()

    def initState(self,state):
        pass

    def _resample_fast(self, data,interval,args,insert_func,state):
        #master time series
        ts=data[self.master_col][:,0]

        #preallocate the resampled array
        #go through the data array to figure out the actual number of 
        #columns we need, might be more than simply len(data) if 
        # --all-- is selected
        num_cols = 0
        for d in data:
            num_cols += np.shape(d)[1]-1
        res = np.empty((len(ts),num_cols+1))
        res[:,0] = ts

        k = 1 #current offset in the res array
        i = 0 #index into the data array
        K = 1 #upper offset in the res array (for --all-- stream mapping)
        for d in data:
            k = K

            #if this array has multiple cols
            K = k+(np.shape(d)[1]-1)#+(i+1)
            if(i==self.master_col):
                #no interpolation just copy over the data
                res[:,k:K]=data[i][:,1:]
                res[:,0] = data[i][:,0] #copy over the timestamps
            else:
                #http://stackoverflow.com/questions/2745329/
                f = interp1d(data[i][:,0],data[i][:,1:],axis=0)
                # Values lower than the min x are extrapolated at the same time
                low = ts < f.x[0]
                if(np.any(low)):
                    res[low,k:K] = f.y[0] + \
                        (ts[low]-f.x[0])*(f.y[1]-f.y[0])/(f.x[1]-f.x[0])
                # Values higher than the maximum "x" are extrapolated at same time
                high = ts > f.x[-1]
                if(np.any(high)):
                    res[high,k:K] = f.y[-1] + \
                        (ts[high]-f.x[-1])*(f.y[-1]-f.y[-2])/(f.x[-1]-f.x[-2])
                # Values inside the interpolation range are interpolated directly
                inside = np.logical_and(ts >= f.x[0], ts <= f.x[-1])
                res[inside,k:K] = f(ts[inside])
            i+=1
        self.filterFunc(res,interval,args,insert_func,state)

    def process(self, function, state, args = None, rows = 100000):
        self.filterFunc = function
        last_ts = self._filter.process(self._resample_fast,state,args,rows)
        return last_ts




if __name__ == "__main__":
    print "Do not call this script directly, must be used by a filter"
    exit(1)
