#!/usr/bin/python

#import json
import pickle
import urllib

class State(object):
    
    def __init__(self,encoded_state=None):
        if(encoded_state!=None):
            pickle_state = urllib.unquote_plus(encoded_state)
            self._state=pickle.loads(pickle_state)
        else:
            self._state = {}

    
    def getState(self):
        state = {}
        for key in self._state:
            state[key]=self._state[key]["data"]
        return state

    def dumpState(self):
        r = dict(self._state)
        for key in self._state:
            if(not r[key]["persistent"]):
                del r[key]

        pickle_state = pickle.dumps(r)
        return urllib.quote_plus(pickle_state)

    def initializeSlot(self,slotName,data,persistent=True):
        self._state[slotName]={"data":data,"persistent":persistent}

    def retrieveSlot(self,slotName):
        return self._state[slotName]["data"]
    
    def updateSlot(self,slotName,data):
        self._state[slotName]["data"] = data
    
if __name__=="__main__":
    s=State()
    s.initializeSlot("one",1)
    s.initializeSlot("two",2,persistent=True)
    s.updateSlot("two",4)
    print "one: %d" % s.retrieveSlot("one")
    str2 = s.dumpState()
    print "state: %s" % str2
    s2 = State(str2)
    print s2._state
    print s2.getState()
