#!/usr/bin/python

# To release a new version, tag it:
#   git tag -a nilmtools-1.1 -m "Version 1.1"
#   git push --tags
# Then just package it up:
#   python setup.py sdist

# This is supposed to be using Distribute:
#
#   distutils provides a "setup" method.
#   setuptools is a set of monkeypatches on top of that.
#   distribute is a particular version/implementation of setuptools.
#
# So we don't really know if this is using the old setuptools or the
# Distribute-provided version of setuptools.

import traceback
import sys
import os

try:
    from setuptools import setup, find_packages
    import distutils.version
except ImportError:
    traceback.print_exc()
    print "Please install the prerequisites listed in README.txt"
    sys.exit(1)

# Versioneer manages version numbers from git tags.
# https://github.com/warner/python-versioneer
import versioneer
versioneer.versionfile_source = 'nilmtools/_version.py'
versioneer.versionfile_build = 'nilmtools/_version.py'
versioneer.tag_prefix = 'nilmtools-'
versioneer.parentdir_prefix = 'nilmtools-'

# Hack to workaround logging/multiprocessing issue:
# https://groups.google.com/d/msg/nose-users/fnJ-kAUbYHQ/_UsLN786ygcJ
try: import multiprocessing
except: pass

# We need a MANIFEST.in.  Generate it here rather than polluting the
# repository with yet another setup-related file.
with open("MANIFEST.in", "w") as m:
    m.write("""
# Root
include README.txt
include setup.py
include versioneer.py
include Makefile
""")

# Run setup
setup(name='nilmtools',
      version = versioneer.get_version(),
      cmdclass = versioneer.get_cmdclass(),
      url = 'https://git.jim.sh/jim/lees/nilmtools.git',
      author = 'Jim Paris, John Donnal',
      description = "NILM Database Tools",
      long_description = "NILM Database Tools",
      license = "Proprietary",
      author_email = 'jim@jtan.com, jdonnal@mit.edu',
      install_requires = [ 'nilmdb >= 1.8.5',
                           'numpy',
                           'scipy',
                           'python-daemon >= 1.5',
			   'requests >= 2.0'
                           'markdown',
                           'jinja2'
                           ],
      packages = [ 'nilmtools',
                   ],
      entry_points = {
          'console_scripts': [
              'nilm-decimate = nilmtools.decimate:main',
              'nilm-decimate-auto = nilmtools.decimate_auto:main',
              'nilm-insert = nilmtools.insert:main',
              'nilm-copy = nilmtools.copy_one:main',
              'nilm-prep = nilmtools.prep:main',
              'nilm-copy-wildcard = nilmtools.copy_wildcard:main',
              'nilm-sinefit = nilmtools.sinefit:main',
              'nilm-cleanup = nilmtools.cleanup:main',
              'nilm-median = nilmtools.median:main',
              'nilm-trainola = nilmtools.trainola:main',
              'nilm-transient = nilmtools.transient:main',
              'nilm-pipewatch = nilmtools.pipewatch:main',
              'nilm-copy-rename = nilmtools.archive:main'
              ],
          },
      zip_safe = False,
      )
