# nilmtools: Tools and utilities for NilmDB

Tools and utilities for interacting with the NILM Database, or writing
programs that interact with the NILM database.

by Jim Paris <jim@jtan.com>

## Prerequisites:

    # Runtime and build environments
    sudo apt-get install python3

    # Create a new Python virtual environment to isolate deps.
    python3 -m venv ../venv
    source ../venv/bin/activate   # run "deactivate" to leave

    # Install all Python dependencies
    pip3 install -r requirements.txt

## Install:

Install it into the virtual environment

    python3 setup.py install

If you want to instead install it system-wide, you will also need to
install the requirements system-wide:

    sudo pip3 install -r requirements.txt
    sudo python3 setup.py install

## Building new tools:

The tools in this package are meant to be installed with `python3
setup.py install`.  If you want to make a new one, an easier way to
develop would be to first install this package, and then copy a
specific script like `src/sinefit.py` to a new location, and modify it
as desired.

To add a tool to the package, place it in `src/` and add the
appropriate configuration to `setup.py`.

