#!/usr/bin/env python3

# To release a new version, tag it:
#   git tag -a nilmtools-1.1 -m "Version 1.1"
#   git push --tags
# Then just package it up:
#   python setup.py sdist

import sys
import os
from setuptools import setup

# Versioneer manages version numbers from git tags.
# https://github.com/warner/python-versioneer
import versioneer

# Get list of requirements to use in `install_requires` below.  Note
# that we don't make a distinction between things that are actually
# required for end-users vs developers (or use `test_requires` or
# anything else) -- just install everything for simplicity.
install_requires = open('requirements.txt').readlines()

# Run setup
setup(name='nilmtools',
      version = versioneer.get_version(),
      cmdclass = versioneer.get_cmdclass(),
      url = 'https://git.jim.sh/nilm/nilmtools.git',
      author = 'Jim Paris',
      description = "NILM Database Tools",
      long_description = "NILM Database Tools",
      license = "Proprietary",
      author_email = 'jim@jtan.com',
      install_requires = install_requires,
      packages = [ 'nilmtools',
                   ],
      entry_points = {
          'console_scripts': [
              'nilm-decimate = nilmtools.decimate:main',
              'nilm-decimate-auto = nilmtools.decimate_auto:main',
              'nilm-insert = nilmtools.insert:main',
              'nilm-copy = nilmtools.copy_one:main',
              'nilm-prep = nilmtools.prep:main',
              'nilm-copy-wildcard = nilmtools.copy_wildcard:main',
              'nilm-sinefit = nilmtools.sinefit:main',
              'nilm-cleanup = nilmtools.cleanup:main',
              'nilm-median = nilmtools.median:main',
              'nilm-trainola = nilmtools.trainola:main',
              'nilm-pipewatch = nilmtools.pipewatch:main',
              ],
          },
      zip_safe = False,
      )
